<?php

require_once 'interface.ConfigProcessor.php';

class XMLConfigProcessor implements ConfigProcessor
{

    public  $xmlfile;
    private $message = '';
    private $xml;


    public function __construct($xmlfile = null)
    {
        if ($xmlfile)
        {
            $this->xmlfile = $xmlfile;
        }
    }

    public function process()
    {
        // Sprawdzamy dostpno wymaganych bibliotek
        if (!$this->checkDeps() or 
            !$this->checkConfigAccess())
        {
            return $this->message;
        }

        $this->xml = simplexml_load_file($this->xmlfile);

        if (!$this->checkPHP() or
            !$this->checkExtensions() or
            !$this->checkConfig())
        {
            return $this->message;
        }
    }

    private function checkConfigAccess()
    {
        $returnValue = false;

        // Sprawdzamy, czy plik konfiguracji istnieje i mona z niego czyta
        if (file_exists($this->xmlfile) and 
            is_readable($this->xmlfile))
        {
            $returnValue = true;
        }
        else
        {
            $this->message .= "Ostrzeenie: " .
                              "Nie mona odczyta pliku konfiguracji.\n";
        }

        // Czyszczenie zbuforowanych danych z systemu plikw
        clearstatcache();

        return $returnValue;
    }

    private function checkDeps()
    {
        $returnValue = true;

        // Sprawdzamy, czy dostpne jest rozszerzenie SimpleXML
        if (!extension_loaded('SimpleXML'))
        {
            $returnValue = false;
            $this->message .= "Ostrzeenie: " .
                              "Brak rozszerzenia SimpleXML.\n";
        }

        return $returnValue;
    }

    public function checkExtensions()
    {
        $returnValue = true;

        // Sprawdzamy dostpno wszystkich wymienionych rozszerze
        $exts = $this->xml->xpath('packages/package');
        foreach ($exts as $ext)
        {
            if (!extension_loaded($ext['name']))
            {
                $returnValue = false;
                $this->message .= "Ostrzeenie: " .
                                  "Brak rozszerzenia" .
                                  $ext['name'] .
                                  ".\n";
            }
        }

        return $returnValue;
    }

    public function checkPHP()
    {
        // Sprawdzamy, czy zapisano wymagania odnonie wersji PHP
        if (count($phpreq = $this->xml->xpath('environment/php')) == 0)
        {
            return true;
        }

        // Spaszczona tablica elementw
        $phpreq = $phpreq[0];

        // Kontrola wersji minimalnej
        if ($phpreq['minversion'] and
            version_compare(phpversion(), 
                        $phpreq['minversion']) < 0)
        {
            $this->message .= "Ostrzeenie: " .
                              "Wersja PHP jest nisza od " . 
                              $phpreq['minversion'] . ".\n";
            return false;
        }

        // Kontrola wersji maksymalnej
        if ($phpreq['maxversion'] and
            version_compare(phpversion(), 
                        $phpreq['maxversion']) > 0)
        {
            $this->message .= "Ostrzeenie: " .
                              "Wersja PHP jest wiksza ni " .
                              $phpreq['maxversion'] . ".\n";
            return false;
        }

        return true;
    }

    public function checkConfig()
    {
        $returnValue = true;

        // Pobranie wszystkich wartoci konfiguracji
        $cfg = ini_get_all();

        // Sprawdzanie poszczeglnych ustawie
        $settings = $this->xml->xpath('environment/setting');
        foreach ($settings as $setting)
        {
            $value = $setting['value'];
            // Konwersja wartoci logicznych do wartoci funkcji ini_get()
            switch (strtolower($value))
            {
                case 'off':
                case '0':
                case 'false':
                case 'no':
                    $value = '';
                    break;
                case 'on':
                case 'true':
                case 'yes':
                    $value = '1';
                    break;
            }

            // Spaszczanie nazwy
            $name = (string) $setting['name'];

            // Kontrola wartoci dyrektywy, a jeeli to konieczne - poprawienie
            if (!array_key_exists($name, $cfg) or
                ($value != 
                 $cfg[$name]['local_value'] and
                 ini_set($name, $setting['value']) === false))
            {
                $returnValue = false;
                $this->message .= "Ostrzeenie: " .
                                  "Dyrektywa" . $name .
                                  " nie ma wymaganej wartoci: "
                                  . $setting['value'] . ".\n";
            }
        }

        return $returnValue;
    }
}

?>
